// Generated by CoffeeScript 1.7.1
(function() {
  var BrowserWindow, EventEmitter, Menu, MenuItem, applicationMenu, bindings, generateGroupId, nextGroupId, v8Util;

  BrowserWindow = require('browser-window');

  EventEmitter = require('events').EventEmitter;

  MenuItem = require('menu-item');

  v8Util = process.atomBinding('v8_util');

  bindings = process.atomBinding('menu');

  nextGroupId = 0;

  generateGroupId = function(items, pos) {
    var i, item, _i, _j, _ref, _ref1;
    if (pos > 0) {
      for (i = _i = _ref = pos - 1; _ref <= 0 ? _i <= 0 : _i >= 0; i = _ref <= 0 ? ++_i : --_i) {
        item = items[i];
        if (item.type === 'radio') {
          return item.groupId;
        }
        if (item.type === 'separator') {
          break;
        }
      }
    } else if (pos < items.length) {
      for (i = _j = pos, _ref1 = items.length - 1; pos <= _ref1 ? _j <= _ref1 : _j >= _ref1; i = pos <= _ref1 ? ++_j : --_j) {
        item = items[i];
        if (item.type === 'radio') {
          return item.groupId;
        }
        if (item.type === 'separator') {
          break;
        }
      }
    }
    return ++nextGroupId;
  };

  Menu = bindings.Menu;

  Menu.prototype.__proto__ = EventEmitter.prototype;

  Menu.prototype._init = function() {
    this.commandsMap = {};
    this.groupsMap = {};
    this.items = [];
    return this.delegate = {
      isCommandIdChecked: (function(_this) {
        return function(commandId) {
          var _ref;
          return (_ref = _this.commandsMap[commandId]) != null ? _ref.checked : void 0;
        };
      })(this),
      isCommandIdEnabled: (function(_this) {
        return function(commandId) {
          var _ref;
          return (_ref = _this.commandsMap[commandId]) != null ? _ref.enabled : void 0;
        };
      })(this),
      isCommandIdVisible: (function(_this) {
        return function(commandId) {
          var _ref;
          return (_ref = _this.commandsMap[commandId]) != null ? _ref.visible : void 0;
        };
      })(this),
      getAcceleratorForCommandId: (function(_this) {
        return function(commandId) {
          var _ref;
          return (_ref = _this.commandsMap[commandId]) != null ? _ref.accelerator : void 0;
        };
      })(this),
      executeCommand: (function(_this) {
        return function(commandId) {
          var _ref;
          return (_ref = _this.commandsMap[commandId]) != null ? _ref.click() : void 0;
        };
      })(this),
      menuWillShow: (function(_this) {
        return function() {
          var checked, group, id, radioItem, _i, _len, _ref, _results;
          _ref = _this.groupsMap;
          _results = [];
          for (id in _ref) {
            group = _ref[id];
            checked = false;
            for (_i = 0, _len = group.length; _i < _len; _i++) {
              radioItem = group[_i];
              if (!radioItem.checked) {
                continue;
              }
              checked = true;
              break;
            }
            if (!checked) {
              _results.push(v8Util.setHiddenValue(group[0], 'checked', true));
            } else {
              _results.push(void 0);
            }
          }
          return _results;
        };
      })(this)
    };
  };

  Menu.prototype.popup = function(window) {
    if ((window != null ? window.constructor : void 0) !== BrowserWindow) {
      throw new TypeError('Invalid window');
    }
    return this._popup(window);
  };

  Menu.prototype.append = function(item) {
    return this.insert(this.getItemCount(), item);
  };

  Menu.prototype.insert = function(pos, item) {
    var _base, _name;
    if ((item != null ? item.constructor : void 0) !== MenuItem) {
      throw new TypeError('Invalid item');
    }
    switch (item.type) {
      case 'normal':
        this.insertItem(pos, item.commandId, item.label);
        break;
      case 'checkbox':
        this.insertCheckItem(pos, item.commandId, item.label);
        break;
      case 'separator':
        this.insertSeparator(pos);
        break;
      case 'submenu':
        this.insertSubMenu(pos, item.commandId, item.label, item.submenu);
        break;
      case 'radio':
        item.overrideReadOnlyProperty('groupId', generateGroupId(this.items, pos));
        if ((_base = this.groupsMap)[_name = item.groupId] == null) {
          _base[_name] = [];
        }
        this.groupsMap[item.groupId].push(item);
        v8Util.setHiddenValue(item, 'checked', item.checked);
        Object.defineProperty(item, 'checked', {
          enumerable: true,
          get: function() {
            return v8Util.getHiddenValue(item, 'checked');
          },
          set: (function(_this) {
            return function(val) {
              var otherItem, _i, _len, _ref;
              _ref = _this.groupsMap[item.groupId];
              for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                otherItem = _ref[_i];
                if (otherItem !== item) {
                  v8Util.setHiddenValue(otherItem, 'checked', false);
                }
              }
              return v8Util.setHiddenValue(item, 'checked', true);
            };
          })(this)
        });
        this.insertRadioItem(pos, item.commandId, item.label, item.groupId);
    }
    if (item.sublabel != null) {
      this.setSublabel(pos, item.sublabel);
    }
    item.overrideReadOnlyProperty('menu', this);
    this.items.splice(pos, 0, item);
    return this.commandsMap[item.commandId] = item;
  };

  Menu.prototype._callMenuWillShow = function() {
    var item, _i, _len, _ref, _ref1, _results;
    if ((_ref = this.delegate) != null) {
      _ref.menuWillShow();
    }
    _ref1 = this.items;
    _results = [];
    for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
      item = _ref1[_i];
      if (item.submenu != null) {
        _results.push(item.submenu._callMenuWillShow());
      }
    }
    return _results;
  };

  applicationMenu = null;

  Menu.setApplicationMenu = function(menu) {
    var w, windows, _i, _len, _results;
    if ((menu != null ? menu.constructor : void 0) !== Menu) {
      throw new TypeError('Invalid menu');
    }
    applicationMenu = menu;
    if (process.platform === 'darwin') {
      menu._callMenuWillShow();
      return bindings.setApplicationMenu(menu);
    } else {
      windows = BrowserWindow.getAllWindows();
      _results = [];
      for (_i = 0, _len = windows.length; _i < _len; _i++) {
        w = windows[_i];
        _results.push(w.setMenu(menu));
      }
      return _results;
    }
  };

  Menu.getApplicationMenu = function() {
    return applicationMenu;
  };

  Menu.sendActionToFirstResponder = bindings.sendActionToFirstResponder;

  Menu.buildFromTemplate = function(template) {
    var item, key, menu, menuItem, value, _i, _len;
    if (!Array.isArray(template)) {
      throw new TypeError('Invalid template for Menu');
    }
    menu = new Menu;
    for (_i = 0, _len = template.length; _i < _len; _i++) {
      item = template[_i];
      if (typeof item !== 'object') {
        throw new TypeError('Invalid template for MenuItem');
      }
      if (item.submenu != null) {
        item.submenu = Menu.buildFromTemplate(item.submenu);
      }
      menuItem = new MenuItem(item);
      for (key in item) {
        value = item[key];
        if (menuItem[key] == null) {
          menuItem[key] = value;
        }
      }
      menu.append(menuItem);
    }
    return menu;
  };

  module.exports = Menu;

}).call(this);
